#include "timeLine.h"

void timeLine::load (ifstream& F)
{
	pts.clear();
	hermitCoef.clear();
	int num;
	F >> num;
	BezPoint pt;
	for (int i = 0; i < num; i++) {
		F >> pt.h1[0] >> pt.h1[1] >> pt.p[0] >> pt.p[1] >> pt.h2[0] >> pt.h2[1];
		pts.push_back(pt);
	}
	improveHermitHandles();
}


void timeLine::improveHermitHandles()
{
	//recalculate time values
	float start = pts[0].p[0];
	cout << "start diff = " << start << endl;
	if (start > 0.0) {
		for (int i = 0; i < pts.size(); i++) {
			pts[i].h1[0] -= start;
			pts[i].p[0] -= start;
			pts[i].h2[0] -= start;
		}
	}
	//rescale timeline to <0,1>
	float len = pts[pts.size()-1].p[0];
	if (len != 1.0) {
		cout << "len diff = " << len << endl;
		for (int i = 0; i < pts.size(); i++) {
			pts[i].h1[0] = pts[i].h1[0] / len;
			pts[i].p[0] = pts[i].p[0] / len;
			pts[i].h2[0] = pts[i].h2[0] / len;
		}
	}
	for (int i=0; i<pts.size(); i++) {
		pts[i].h1 = (pts[i].p-pts[i].h1)*(1.0/3.0) + pts[i].p;
		pts[i].h2 = (pts[i].p-pts[i].h2)*(1.0/3.0) + pts[i].p;
	}
	hermitCoef.resize(pts.size()-1);
	for (int i=0; i<pts.size()-1; i++) hermitCreate(pts[i], pts[i+1], i);
}

float timeLine::eval(float t)	// t = <0,1>
{
	if (t<0.0) return pts[0].p[1];
	if (t>1.0) return pts[pts.size()-1].p[1];
	int i=0;
	while (t > pts[i+1].p[0]) i++;
	return evalHermit(i, t);
}

float timeLine::evalHermit(int i, float time)

{
	float t = time - hermitCoef[i].a;
	return (t*(t*(t*hermitCoef[i].b + hermitCoef[i].c)+hermitCoef[i].d)+hermitCoef[i].e);
}

void timeLine::hermitCreate(BezPoint& p1, BezPoint& p2, int hi)
{
	#define MAXTAN 5729577.9485111479
	float dx,dy,tan_x,m1,m2,len,d1,d2;
	hermitCoef[hi].a = p1.p[0];
	dx = p2.p[0] - p1.p[0];
	dy = p2.p[1] - p1.p[1];
	m1 = MAXTAN;
	m2 = MAXTAN;
	tan_x = p1.h2[0] - p1.p[0];
	if (tan_x != 0.0) m1 = (p1.h2[1] - p1.p[1])/tan_x;
	tan_x = p2.h1[0] - p2.p[0];
	if (tan_x != 0.0) m2 = (p2.h1[1] - p2.p[1])/tan_x;
	len = 1.0/(dx*dx);
	d1 = dx*m1;
	d2 = dx*m2;
	hermitCoef[hi].b = (d1+d2-dy-dy)*len/dx;
	hermitCoef[hi].c = (dy+dy+dy-d1-d1-d2)*len;
	hermitCoef[hi].d = m1;
	hermitCoef[hi].e = p1.p[1];
	#undef MAXTAN
}
