#include "noise0Fragment.h"

unsigned char noise0Fragment::texdata[512*512];
unsigned char noise0Fragment::randt[32768];
int noise0Fragment::startRand;
int noise0Fragment::incRand;
int noise0Fragment::randModulo;
GLuint noise0Fragment::glTex;

void noise0Fragment::prepareData()
{
	glGenTextures(1, &glTex);
	glBindTexture(GL_TEXTURE_2D, glTex);
	glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE); //texture blend with object background
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	//else glTexImage2D(target,0,mode,width,height,0,mode,GL_UNSIGNED_BYTE,data);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_ALPHA, 512, 512, 0, GL_ALPHA, GL_UNSIGNED_BYTE, texdata);
	for (int i = 0; i < 32768; i++) randt[i] = (rand() % (128 + 32)) + 16;
	randModulo = 100;
	startRand = 0;
}


void noise0Fragment::init(void) 
{
	internalTime = startTime = glfwGetTime();
	alpha = 0.4;
	alive = true;
}

void noise0Fragment::draw(float dt) 
{
	#define FRLEN 1.0
	
	float t=glfwGetTime()-startTime;
	float tt=t/FRLEN;

	/*if (t>FRLEN) {
		alive = false;
		return;
	}*/

	glPushAttrib(GL_ALL_ATTRIB_BITS);

	glPushMatrix();
	glLoadIdentity();
	internalTime += dt;
	if (internalTime > 0.02) {
		incRand += (rand() % randModulo) + 1;
		unsigned char pix;
		for (int i = 0; i < 512*512; i++) {
			texdata[i] = randt[startRand];
			startRand = (startRand + incRand) & 32767;
		}
		internalTime = 0;
	}
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, glTex);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_ALPHA, 512, 512, 0, GL_ALPHA, GL_UNSIGNED_BYTE, texdata);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	//glColor4f(1, 1, 1, (1.0-tt)*0.8);
	glColor4f(1, 1, 1,alpha);
	glBegin(GL_QUADS);
	glTexCoord2f(1, 0); glVertex2f(-4, -3);
	glTexCoord2f(0, 0); glVertex2f(4, -3);
	glTexCoord2f(0, 1); glVertex2f(4, 3);
	glTexCoord2f(1, 1); glVertex2f(-4, 3);
	glEnd();
	glPopMatrix();
	
	glPopAttrib();
	
	#undef FRLEN
}

void noise0Fragment::done(void) 
{
	glDeleteTextures(1, &glTex);
	alive = false;
}


