#include "music.h"

using namespace std;

static bool Music_Enabled;
static int Music_Channel;

static FSOUND_STREAM* stream;
static FSOUND_DSPUNIT* fftdsp;

bool MusicInit(const char* fileName)
{
	Music_Channel = -1;
	Music_Enabled = false;
	stream = NULL;

	if (!FSOUND_SetBufferSize(200))
		cerr << FMOD_ErrorString(FSOUND_GetError()) << endl;
	//FSOUND_OUTPUT_WINMM - windows multimedia driver
	//FSOUND_OUTPUT_DSOUND - direct sound driver. You need this to get EAX2 or EAX3 support, or FX api support.
	if (!FSOUND_SetOutput(FSOUND_OUTPUT_DSOUND))
		cerr << FMOD_ErrorString(FSOUND_GetError()) << endl;
	if (!FSOUND_SetDriver(0))
		cerr << FMOD_ErrorString(FSOUND_GetError()) << endl;
	if (!FSOUND_SetMixer(FSOUND_MIXER_QUALITY_AUTODETECT))
		cerr << FMOD_ErrorString(FSOUND_GetError()) << endl;
	if (!FSOUND_Init(44100,32,0)) {
		cerr << FMOD_ErrorString(FSOUND_GetError()) << endl;
		return false;
	}
	Music_Enabled = true;

	stream = FSOUND_Stream_Open(fileName, FSOUND_NORMAL, 0,0);
	if (stream == NULL) return false;
	Music_Channel = FSOUND_Stream_PlayEx(FSOUND_FREE, stream, 0, FALSE);
	if (Music_Channel != -1) {
		FSOUND_SetPaused(Music_Channel, FALSE);
		fftdsp = FSOUND_DSP_GetFFTUnit();
		FSOUND_DSP_SetActive(fftdsp, TRUE);
	}
	else return false;

	return true;
}

void MusicDone()
{
	if (!Music_Enabled) return;
	if (Music_Channel != -1)
		FSOUND_SetPaused(Music_Channel, TRUE);
	if (fftdsp)
		FSOUND_DSP_Free(fftdsp);
	if (stream)
		FSOUND_Stream_Close(stream);
	FSOUND_Close();
}

float* MusicGetSpectrum()
{
	if (!Music_Enabled) return NULL;
	float *spec = FSOUND_DSP_GetSpectrum();
	return spec;
}
